#--------------------------------------------------------------------------
#  This script shows how to make use of the history information
#
#  It repeats the last unfolding of the script 'demo_fast-Loop.R'
#  and then has to be called after it:
#
#     > source("demo_fast_loop.R")
#     > source("using_history.R")
#
#--------------------------------------------------------------------------

# call again the last step of the unfolding
# (using the n.iter-1 priors)
# but this time requiring the history

unfolded <- MC.unfold (prior, mc.smear$alpha, obs, N=1000, HISTORY=TRUE)

# what does the object 'unfolded' contain?
cat( sprintf( "Let us give a look at what is contained in 'unfolded':\n") )
str(unfolded)

# the history of sampling of cause 1 is stored in unfolded$x[,1], and so on

# summaries of causes 1 and 2, as well as their correlations
cat( sprintf( "\nsummaries of causes 1 and 2, as well as their correlations:\n") )
mean.C1  <- mean(unfolded$x[,1])
sigma.C1 <- sd(unfolded$x[,1])

cat( sprintf( "\n    Cause 1: mean=%.2f, sigma=%.2f \n", mean.C1, sigma.C1 ) )
cat( sprintf( "     [Note they do not need to be absolutely identical to above numbers\n") )
cat( sprintf( "     because they result from a MC integration]\n") )

mean.C2  <- mean(unfolded$x[,2])
sigma.C2 <- sd(unfolded$x[,2])
cat( sprintf( "\n     Cause 2: mean=%.2f, sigma=%.2f \n", mean.C2, sigma.C2 ) )
cat( sprintf( "    [same remark]\n") )

rho.C1C2 <- cor(unfolded$x[,1], unfolded$x[,2])
cat( sprintf( "\n     Correlation coefficient between C1 and C2: %.3f\n", rho.C1C2) )
    

# Plot to show the details of the sampling for each cause-bin
par (mfrow= c(2,5) )   # optimized for nC=10
for (i in 1:nC) hist( unfolded$x[,i], nc=40, xlab=sprintf("bin %d",i), main='unfolded evts')
par (mfrow= c(1,1) )   # set back frame to default
cat ( sprintf("\n\nWatch at the history details of cause-bins (histograms) \n"))
cat ( sprintf("(you might want to enlarge the graphics window using the mouse)\n"))

# then you can repeat it
cat ( sprintf("\n     [... then you might want to issue again source(\"using_history.R\")] \n\n"))

